package org.example.common.domain;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.example.common.enums.HttpCodeEnum;

import java.io.Serializable;

/**
 * 响应信息主体
 *
 * @author Lion Li
 */
@Data
@NoArgsConstructor
public class R<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 消息状态码
     */
    private int code;

    /**
     * 消息内容
     */
    private String msg;

    /**
     * 数据对象
     */
    private T data;

    public static <T> R<T> ok() {
        return restResult(null, HttpCodeEnum.SUCCESS);
    }

    public static <T> R<T> ok(T data) {
        return restResult(data, HttpCodeEnum.SUCCESS);
    }

    public static <T> R<T> ok(String msg, T data) {
        return restResult(data, HttpCodeEnum.SUCCESS.getCode(), msg);
    }

    public static <T> R<T> fail() {
        return restResult(null, HttpCodeEnum.ERROR);
    }

    public static <T> R<T> fail(String msg) {
        return restResult(null, HttpCodeEnum.ERROR.getCode(), msg);
    }
    public static <T> R<T> fail(String msg, T data) {
        return restResult(data, HttpCodeEnum.ERROR.getCode(), msg);
    }

    public static <T> R<T> result(HttpCodeEnum httpCodeEnum) {
        return restResult(null,httpCodeEnum);
    }
    public static <T> R<T> result(boolean isSuccess) {
        return isSuccess ? ok() : fail();
    }
    private static <T> R<T> restResult(T data, HttpCodeEnum httpCodeEnum) {
        R<T> r = new R<>();
        r.setCode(httpCodeEnum.getCode());
        r.setData(data);
        r.setMsg(httpCodeEnum.getDesc());
        return r;
    }
    private static <T> R<T> restResult(T data, int code, String msg) {
        R<T> r = new R<>();
        r.setCode(code);
        r.setData(data);
        r.setMsg(msg);
        return r;
    }

    public static <T> Boolean isError(R<T> ret) {
        return !isSuccess(ret);
    }

    public static <T> Boolean isSuccess(R<T> ret) {
        return HttpCodeEnum.SUCCESS.getCode() == ret.getCode();
    }

}
