package org.example.common.thirty.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.example.common.thirty.IdentityCardService;
import org.example.common.util.HttpUtil;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * @author liutao
 * @since 2024/3/21
 */
@Slf4j
@Service
public class IdentityCardServiceImpl implements IdentityCardService {

    private static final String URL = "https://zid.market.alicloudapi.com/idcard/VerifyIdcardv2?cardNo=%s&realName=%s";
    private static final String APP_CODE = "0411efcfca8d4d26898c68f48a974f26";
    @Override
    public boolean validateIdentityCard(String identityCard, String name) {
        try {
            // 去除空格
            name = StringUtils.trimAllWhitespace(name);
            identityCard = StringUtils.trimAllWhitespace(identityCard);
            // 调用http请求
            JSONObject response = HttpUtil.get(String.format(URL, identityCard, name), MapUtil.of("Authorization", "APPCODE " + APP_CODE),JSONObject.class);
            log.info("身份证验证响应:{}", response.toJSONString());
            Integer errorCode = response.getInteger("error_code");
            if (errorCode != 0) {
                return false;
            }
            JSONObject result = response.getJSONObject("result");
            if (result == null) {
                return false;
            }
            return result.getBoolean("isok");
        } catch (Exception e) {
            log.error("身份证校验异常{}", e.getMessage(), e);
            return true;
        }
    }
}
