package org.example.common.thirty.impl;

import cn.hutool.core.lang.Validator;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.dytnsapi20200217.Client;
import com.aliyun.dytnsapi20200217.models.DescribePhoneNumberOperatorAttributeRequest;
import com.aliyun.dytnsapi20200217.models.DescribePhoneNumberOperatorAttributeResponse;
import com.aliyun.dytnsapi20200217.models.DescribePhoneNumberOperatorAttributeResponseBody;
import com.aliyun.teaopenapi.models.Config;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.common.enums.PhoneNumberOperatorAttributeCode;
import org.example.common.thirty.PhoneNumberOperatorAttributeService;
import org.example.common.thirty.entity.PhoneNumberAttribute;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

/**
 * @author liutao
 * @since 2024/4/22
 */
@Slf4j
@Service
@ConditionalOnProperty(name = "mobile.operator.attribute.enable", havingValue = "true")
public class PhoneNumberOperatorAttributeServiceImpl implements PhoneNumberOperatorAttributeService {


    private Client client;
    @Value("${mobile.operator.attribute.accessKeyId}")
    private String accessKeyId;
    @Value("${mobile.operator.attribute.accessKeySecret}")
    private String accessKeySecret;
    @Value("${mobile.operator.attribute.authCode}")
    private String authCode;


    @PostConstruct
    public void init() throws Exception {
        Config config = new Config()
                // 必填，您的 AccessKey ID
                .setAccessKeyId(accessKeyId)
                // 必填，您的 AccessKey Secret
                .setAccessKeySecret(accessKeySecret)
                // 访问的域名
                .setEndpoint("dytnsapi.aliyuncs.com");

        this.client = new Client(config);
    }

    @Override
    public PhoneNumberAttribute queryPhoneAttribute(String phone) {
        log.info("查询归属地手机号： {}",phone);
        if(!Validator.isMobile(phone)){
            log.warn("手机号格式错误： {}",phone);
            return null;
        }
        DescribePhoneNumberOperatorAttributeRequest request = new DescribePhoneNumberOperatorAttributeRequest()
                .setAuthCode(authCode)
                .setInputNumber(SecureUtil.md5(phone))
                .setMask("MD5");
        try {
            DescribePhoneNumberOperatorAttributeResponse response = client.describePhoneNumberOperatorAttribute(request);
            DescribePhoneNumberOperatorAttributeResponseBody body = response.getBody();
            if (body.getCode().equals(PhoneNumberOperatorAttributeCode.OK.getCode())) {
                DescribePhoneNumberOperatorAttributeResponseBody.DescribePhoneNumberOperatorAttributeResponseBodyData data = body.getData();
                log.info("归属地信息：{}", JSON.toJSONString(data));
                return new PhoneNumberAttribute(data.getBasicCarrier(),
                        data.getCarrier(),
                        data.getCity(),
                        data.getIsNumberPortability(),
                        data.getNumberSegment(),
                        data.getProvince(),
                        body.getCode());
            }

        } catch (Exception e) {
            log.error("查询归属地失败：{}", phone);
            log.error(e.getMessage(),e);
        }
        return null;
    }
}
