/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.cache;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.example.common.cache.conversion.TypeConversion;
import org.example.common.lock.DistributedLock;
import org.example.common.lock.factory.DistributedLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisCacheService {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheService.class);
    private static final Long CACHE_NULL_TTL = 60L;
    private static final String EMPTY_VALUE = "";
    private static final String EMPTY_LIST_VALUE = "[]";
    private static final String LOCK_SUFFIX = "_lock";
    private static final long THREAD_SLEEP_MILLISECONDS = 50L;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private DistributedLockFactory distributedLockFactory;

    public void set(String key, Object value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)this.getValue(value));
    }

    public void set(String key, Object value, Long timeout, TimeUnit unit) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)this.getValue(value), timeout.longValue(), unit);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.stringRedisTemplate.expire((Object)key, timeout, unit);
    }

    public Long addSet(String key, String ... values) {
        return this.stringRedisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    public Boolean isMemberSet(String key, Object value) {
        return this.stringRedisTemplate.opsForSet().isMember((Object)key, (Object)value.toString());
    }

    public Set<String> membersSet(String key) {
        return this.stringRedisTemplate.opsForSet().members((Object)key);
    }

    public Long removeSet(String key, Object ... values) {
        return this.stringRedisTemplate.opsForSet().remove((Object)key, values);
    }

    public Long sizeSet(String key) {
        return this.stringRedisTemplate.opsForSet().size((Object)key);
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public <T> T getObject(String key, Class<T> targetClass) {
        Object result = this.stringRedisTemplate.opsForValue().get((Object)key);
        if (result == null) {
            return null;
        }
        try {
            return (T)JSON.parseObject((String)result.toString(), targetClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> multiGet(Collection<String> keys) {
        return this.stringRedisTemplate.opsForValue().multiGet(keys);
    }

    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)pattern);
    }

    public Boolean delete(String key) {
        if (StrUtil.isEmpty((CharSequence)key)) {
            return false;
        }
        return this.stringRedisTemplate.delete((Object)key);
    }

    public <R, ID> R queryWithPassThrough(String keyPrefix, ID id, Class<R> type, Function<ID, R> dbFallback, Long timeout, TimeUnit unit) {
        String key = this.getKey(keyPrefix, id);
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isNotBlank((CharSequence)str)) {
            return this.getResult(str, type);
        }
        if (str != null) {
            return null;
        }
        R r = dbFallback.apply(id);
        if (r == null) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)EMPTY_VALUE, CACHE_NULL_TTL.longValue(), TimeUnit.SECONDS);
            return null;
        }
        this.set(key, r, timeout, unit);
        return r;
    }

    public <R> R queryWithPassThroughWithoutArgs(String keyPrefix, Class<R> type, Supplier<R> dbFallback, Long timeout, TimeUnit unit) {
        String key = this.getKey(keyPrefix);
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isNotBlank((CharSequence)str)) {
            return this.getResult(str, type);
        }
        if (str != null) {
            return null;
        }
        R r = dbFallback.get();
        if (r == null) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)EMPTY_VALUE, CACHE_NULL_TTL.longValue(), TimeUnit.SECONDS);
            return null;
        }
        this.set(key, r, timeout, unit);
        return r;
    }

    public <R, ID> List<R> queryWithPassThroughList(String keyPrefix, ID id, Class<R> type, Function<ID, List<R>> dbFallback, Long timeout, TimeUnit unit) {
        String key = this.getKey(keyPrefix, id);
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isNotBlank((CharSequence)str)) {
            return this.getResultList(str, type);
        }
        if (str != null) {
            return null;
        }
        List<R> r = dbFallback.apply(id);
        if (r == null || r.isEmpty()) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)EMPTY_VALUE, CACHE_NULL_TTL.longValue(), TimeUnit.SECONDS);
            return Collections.emptyList();
        }
        this.set(key, r, timeout, unit);
        return r;
    }

    public <R> List<R> queryWithPassThroughListWithoutArgs(String keyPrefix, Class<R> type, Supplier<List<R>> dbFallback, Long timeout, TimeUnit unit) {
        String key = this.getKey(keyPrefix);
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isNotBlank((CharSequence)str)) {
            return this.getResultList(str, type);
        }
        if (str != null) {
            return null;
        }
        List<R> r = dbFallback.get();
        if (r == null || r.isEmpty()) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)EMPTY_VALUE, CACHE_NULL_TTL.longValue(), TimeUnit.SECONDS);
            return null;
        }
        this.set(key, r, timeout, unit);
        return r;
    }

    public <R, ID> R queryWithMutex(String keyPrefix, ID id, Class<R> type, Function<ID, R> dbFallback, Long timeout, TimeUnit unit) {
        String key = this.getKey(keyPrefix, id);
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isNotBlank((CharSequence)str)) {
            return this.getResult(str, type);
        }
        if (str != null) {
            return null;
        }
        String lockKey = this.getLockKey(key);
        R r = null;
        DistributedLock distributedLock = this.distributedLockFactory.getDistributedLock(lockKey);
        try {
            boolean isLock = distributedLock.tryLock();
            if (!isLock) {
                Thread.sleep(50L);
                R r2 = this.queryWithMutex(keyPrefix, id, type, dbFallback, timeout, unit);
                return r2;
            }
            str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            if (StrUtil.isNotBlank((CharSequence)str)) {
                R r3 = this.getResult(str, type);
                return r3;
            }
            r = dbFallback.apply(id);
            if (r == null) {
                this.set(key, EMPTY_VALUE, CACHE_NULL_TTL, TimeUnit.SECONDS);
                R r4 = null;
                return r4;
            }
            this.set(key, r, timeout, unit);
        }
        catch (InterruptedException e) {
            log.error("query data with mutex |{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            distributedLock.unlock();
        }
        return r;
    }

    public <R> R queryWithMutexWithoutArgs(String keyPrefix, Class<R> type, Supplier<R> dbFallback, Long timeout, TimeUnit unit) {
        String key = this.getKey(keyPrefix);
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isNotBlank((CharSequence)str)) {
            return this.getResult(str, type);
        }
        if (str != null) {
            return null;
        }
        String lockKey = this.getLockKey(key);
        R r = null;
        DistributedLock distributedLock = this.distributedLockFactory.getDistributedLock(lockKey);
        try {
            boolean isLock = distributedLock.tryLock();
            if (!isLock) {
                Thread.sleep(50L);
                R r2 = this.queryWithMutexWithoutArgs(keyPrefix, type, dbFallback, timeout, unit);
                return r2;
            }
            str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            if (StrUtil.isNotBlank((CharSequence)str)) {
                R r3 = this.getResult(str, type);
                return r3;
            }
            r = dbFallback.get();
            if (r == null) {
                this.set(key, EMPTY_VALUE, CACHE_NULL_TTL, TimeUnit.SECONDS);
                R r4 = null;
                return r4;
            }
            this.set(key, r, timeout, unit);
        }
        catch (InterruptedException e) {
            log.error("query data with mutex |{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            distributedLock.unlock();
        }
        return r;
    }

    public <R, ID> List<R> queryWithMutexList(String keyPrefix, ID id, Class<R> type, Function<ID, List<R>> dbFallback, Long timeout, TimeUnit unit) {
        String key = this.getKey(keyPrefix, id);
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isNotBlank((CharSequence)str)) {
            return this.getResultList(str, type);
        }
        if (str != null) {
            return null;
        }
        String lockKey = this.getLockKey(key);
        List<R> list = null;
        DistributedLock distributedLock = this.distributedLockFactory.getDistributedLock(lockKey);
        try {
            boolean isLock = distributedLock.tryLock();
            if (!isLock) {
                Thread.sleep(50L);
                List<R> list2 = this.queryWithMutexList(keyPrefix, id, type, dbFallback, timeout, unit);
                return list2;
            }
            str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            if (StrUtil.isNotBlank((CharSequence)str)) {
                List<R> list3 = this.getResultList(str, type);
                return list3;
            }
            list = dbFallback.apply(id);
            if (list == null) {
                this.stringRedisTemplate.opsForValue().set((Object)key, (Object)EMPTY_VALUE, CACHE_NULL_TTL.longValue(), TimeUnit.SECONDS);
                List<R> list4 = null;
                return list4;
            }
            this.set(key, list, timeout, unit);
        }
        catch (InterruptedException e) {
            log.error("query data with mutex list |{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            distributedLock.unlock();
        }
        return list;
    }

    public <R> List<R> queryWithMutexListWithoutArgs(String keyPrefix, Class<R> type, Supplier<List<R>> dbFallback, Long timeout, TimeUnit unit) {
        String key = this.getKey(keyPrefix);
        String str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isNotBlank((CharSequence)str)) {
            return this.getResultList(str, type);
        }
        if (str != null) {
            return null;
        }
        String lockKey = this.getLockKey(key);
        List<R> list = null;
        DistributedLock distributedLock = this.distributedLockFactory.getDistributedLock(lockKey);
        try {
            boolean isLock = distributedLock.tryLock();
            if (!isLock) {
                Thread.sleep(50L);
                List<R> list2 = this.queryWithMutexListWithoutArgs(keyPrefix, type, dbFallback, timeout, unit);
                return list2;
            }
            str = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            if (StrUtil.isNotBlank((CharSequence)str)) {
                List<R> list3 = this.getResultList(str, type);
                return list3;
            }
            list = dbFallback.get();
            if (list == null) {
                this.stringRedisTemplate.opsForValue().set((Object)key, (Object)EMPTY_VALUE, CACHE_NULL_TTL.longValue(), TimeUnit.SECONDS);
                List<R> list4 = null;
                return list4;
            }
            this.set(key, list, timeout, unit);
        }
        catch (InterruptedException e) {
            log.error("query data with mutex list |{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            distributedLock.unlock();
        }
        return list;
    }

    private String getLockKey(String key) {
        return key.concat(LOCK_SUFFIX);
    }

    private <R> R getResult(Object obj, Class<R> type) {
        if (obj == null) {
            return null;
        }
        if (TypeConversion.isSimpleType(obj)) {
            return (R)Convert.convert(type, (Object)obj);
        }
        return (R)JSON.parseObject((String)JSON.toJSONString((Object)obj), type);
    }

    private <R> List<R> getResultList(String str, Class<R> type) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        return JSON.parseArray((String)str, type);
    }

    private String getKey(String key) {
        return this.getKey(key, null);
    }

    private <ID> String getKey(String keyPrefix, ID id) {
        if (id == null) {
            return keyPrefix;
        }
        String key = EMPTY_VALUE;
        key = TypeConversion.isSimpleType(id) ? StrUtil.toString(id) : SecureUtil.md5((String)JSON.toJSONString(id));
        if (StrUtil.isEmpty((CharSequence)key)) {
            key = EMPTY_VALUE;
        }
        return keyPrefix.concat(key);
    }

    private String getValue(Object value) {
        return TypeConversion.isSimpleType(value) ? String.valueOf(value) : JSON.toJSONString((Object)value);
    }

    public boolean exists(String key) {
        return BooleanUtil.isTrue((Boolean)this.stringRedisTemplate.hasKey((Object)key));
    }
}

