/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.domain;

import java.io.Serializable;
import org.example.common.enums.HttpCodeEnum;

public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int code;
    private String message;
    private T data;

    public static <T> R<T> ok() {
        return R.restResult(null, HttpCodeEnum.SUCCESS);
    }

    public static <T> R<T> ok(T data) {
        return R.restResult(data, HttpCodeEnum.SUCCESS);
    }

    public static <T> R<T> ok(String msg, T data) {
        return R.restResult(data, HttpCodeEnum.SUCCESS.getCode(), msg);
    }

    public static <T> R<T> fail() {
        return R.restResult(null, HttpCodeEnum.ERROR);
    }

    public static <T> R<T> fail(String msg) {
        return R.restResult(null, HttpCodeEnum.ERROR.getCode(), msg);
    }

    public static <T> R<T> fail(String msg, T data) {
        return R.restResult(data, HttpCodeEnum.ERROR.getCode(), msg);
    }

    public static <T> R<T> result(HttpCodeEnum httpCodeEnum) {
        return R.restResult(null, httpCodeEnum);
    }

    public static <T> R<T> result(boolean isSuccess) {
        return isSuccess ? R.ok() : R.fail();
    }

    private static <T> R<T> restResult(T data, HttpCodeEnum httpCodeEnum) {
        R<T> r = new R<T>();
        r.setCode(httpCodeEnum.getCode());
        r.setData(data);
        r.setMessage(httpCodeEnum.getDesc());
        return r;
    }

    private static <T> R<T> restResult(T data, int code, String msg) {
        R<T> r = new R<T>();
        r.setCode(code);
        r.setData(data);
        r.setMessage(msg);
        return r;
    }

    public static <T> Boolean isError(R<T> ret) {
        return R.isSuccess(ret) == false;
    }

    public static <T> Boolean isSuccess(R<T> ret) {
        return HttpCodeEnum.SUCCESS.getCode() == ret.getCode();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof R)) {
            return false;
        }
        R other = (R)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof R;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

