/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.id;

import cn.hutool.core.lang.Snowflake;
import com.github.yitter.contract.IdGeneratorOptions;
import com.github.yitter.idgen.YitIdHelper;
import javax.annotation.PostConstruct;
import org.example.common.enums.IdType;
import org.example.common.id.IdGenerateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SnowFlakeIdGenerateServiceImpl
implements IdGenerateService {
    private static final Logger log = LoggerFactory.getLogger(SnowFlakeIdGenerateServiceImpl.class);
    @Value(value="${snowFlake.workerId:0}")
    private Short workerId;
    private Snowflake snowFlake;

    @PostConstruct
    public void init() {
        IdGeneratorOptions options = new IdGeneratorOptions(this.workerId.shortValue());
        YitIdHelper.setIdGenerator((IdGeneratorOptions)options);
    }

    @Override
    public Long nextId() {
        return YitIdHelper.nextId();
    }

    @Override
    public String nextIdStr(IdType idType) {
        return this.nextIdStr() + idType.getType();
    }

    @Override
    public String nextIdStr() {
        return String.valueOf(this.nextId());
    }
}

