/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.oss;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.example.common.oss.OssProperties;
import org.example.common.oss.OssService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"oss.enable"}, havingValue="true")
public class OssServiceImpl
implements OssService {
    private static final Logger log = LoggerFactory.getLogger(OssServiceImpl.class);
    private OSSClient ossClient;
    @Resource
    private OssProperties ossProperties;

    @PostConstruct
    public void init() {
        this.ossClient = new OSSClient(this.ossProperties.getEndpoint(), this.ossProperties.getAccessKeyId(), this.ossProperties.getSecretAccessKey());
    }

    @Override
    public String uploadObject(InputStream is, String filePath, boolean isHttps) {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        String bucketName = this.ossProperties.getBucketName();
        this.ossClient.putObject(bucketName, filePath, is);
        String httpPrefix = isHttps ? "https://" : "http://";
        String endpoint = this.ossProperties.getEndpoint();
        if (!endpoint.endsWith("/")) {
            endpoint = endpoint + "/";
        }
        return httpPrefix + bucketName + "." + endpoint + filePath;
    }

    @Override
    public Boolean exists(String path) {
        return this.ossClient.doesObjectExist(this.ossProperties.getBucketName(), path);
    }

    @Override
    public String uploadObject(InputStream is, String filePath) {
        return this.uploadObject(is, filePath, false);
    }

    @Override
    public Map<String, Object> getPostSignature(String key) {
        String host = "https://" + this.ossProperties.getBucketName() + "." + this.ossProperties.getEndpoint();
        try {
            long expireTime = 3600L;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConditions = new PolicyConditions();
            policyConditions.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConditions.addConditionItem(MatchMode.StartWith, "key", key);
            String postPolicy = this.ossClient.generatePostPolicy((java.util.Date)expiration, policyConditions);
            byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = this.ossClient.calculatePostSignature(postPolicy);
            JSONObject respMap = new JSONObject();
            respMap.put("OSSAccessKeyId", (Object)this.ossProperties.getAccessKeyId());
            respMap.put("policy", (Object)encodedPolicy);
            respMap.put("signature", (Object)postSignature);
            respMap.put("host", (Object)host);
            respMap.put("expire", (Object)String.valueOf(expireEndTime / 1000L));
            respMap.put("key", (Object)key);
            return respMap;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6oss\u4e0a\u4f20\u7b7e\u540d\u5931\u8d25");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

