/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.thirty.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.example.common.enums.ShortLinkChannelEnum;
import org.example.common.exception.ApiCallException;
import org.example.common.exception.ServiceException;
import org.example.common.exception.ShortUrlException;
import org.example.common.thirty.ShortLinkService;
import org.example.common.thirty.entity.ShortLinkGenerateRequest;
import org.example.common.util.HttpUtil;
import org.example.common.util.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BaiduShortLinkServiceImpl
implements ShortLinkService {
    private static final String HOST = "https://dwz.cn/api/v3/short-urls";
    private static final String TOKEN = "95a4fd37cd17d26f8467b9d30d58ecd9";
    private static final String CONTENT_TYPE = "application/json; charset=UTF-8";
    private static final String TERM_OF_VALIDITY = "1-year";
    private static final String SHORT_URL_KEY = "ShortUrl";
    private static final Map<String, String> HEADERS = new HashMap<String, String>(3);

    @PostConstruct
    public void initHeaders() {
        HEADERS.put("Dwz-Token", TOKEN);
        HEADERS.put("Content-Language", "zh");
    }

    @Override
    public String create(ShortLinkGenerateRequest request) {
        return this.create(request.getLongUrl(), request.getQuery());
    }

    @Override
    public String create(String longUrl) {
        return this.create(longUrl, null);
    }

    @Override
    public String create(String longUrl, Map<String, Object> query) {
        if (StringUtils.isBlank((CharSequence)longUrl)) {
            throw new ServiceException("\u957f\u94fe\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty(query)) {
            longUrl = longUrl.contains("?") ? longUrl + "&" + this.getQueryString(query) : longUrl + "?" + this.getQueryString(query);
        }
        List<String> shortUrls = this.create(CollectionUtil.newArrayList((Object[])new String[]{longUrl}));
        return shortUrls.get(0);
    }

    @Override
    public ShortLinkChannelEnum type() {
        return ShortLinkChannelEnum.Baidu;
    }

    private List<String> create(List<String> longUrls) {
        if (CollectionUtils.isEmpty(longUrls)) {
            throw new ShortUrlException("\u957f\u94fe\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List jsonArray = longUrls.stream().map(longUrl -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("LongUrl", longUrl);
            jsonObject.put("TermOfValidity", (Object)TERM_OF_VALIDITY);
            return jsonObject;
        }).collect(Collectors.toList());
        HEADERS.put("Content-Type", CONTENT_TYPE);
        JSONObject response = HttpUtil.post(HOST, HEADERS, JSON.toJSONString(jsonArray), JSONObject.class);
        if (response.getInteger("Code") != 0) {
            throw new ApiCallException("\u767e\u5ea6\u77ed\u94feAPI\u8c03\u7528\u5931\u8d25: " + response.getString("ErrMsg"));
        }
        return this.extractShortUrls(response.getJSONArray("ShortUrls"));
    }

    private List<String> extractShortUrls(JSONArray shortUrlsArray) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object shortUrlObj : shortUrlsArray) {
            JSONObject jsonObject = shortUrlObj instanceof JSONObject ? (JSONObject)shortUrlObj : JSON.parseObject((String)JSON.toJSONString(shortUrlObj));
            String shortUrl = jsonObject.getString(SHORT_URL_KEY);
            result.add(shortUrl);
        }
        return result;
    }
}

