/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.thirty.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import org.example.common.thirty.TycService;
import org.example.common.thirty.entity.Company;
import org.example.common.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"tyc.enable"}, havingValue="true")
public class TycServiceImpl
implements TycService {
    private static final Logger log = LoggerFactory.getLogger(TycServiceImpl.class);
    String TYC_COMPANY_SEARCH_URL = "http://open.api.tianyancha.com/services/open/search/2.0?word=%s&pageSize=%s&pageNum=%s";
    String TYC_TOKEN_NAME = "Authorization";
    String REASON = "reason";
    String RESULT = "result";
    String ITEMS = "items";
    Integer MAX_PAGE_SIZE = 20;
    String SUCCESS_REASON = "ok";
    @Value(value="${tyc.token}")
    private String token;

    @Override
    public List<Company> queryCompanyInfo(String name, Integer pageNum) {
        try {
            JSONObject jsonObject = HttpUtil.get(String.format(this.TYC_COMPANY_SEARCH_URL, name, this.MAX_PAGE_SIZE, pageNum), MapUtil.of((Object)this.TYC_TOKEN_NAME, (Object)this.token), JSONObject.class);
            String reason = jsonObject.getString(this.REASON);
            if (this.SUCCESS_REASON.equals(reason)) {
                JSONObject result = jsonObject.getJSONObject(this.RESULT);
                if (result != null) {
                    return result.getJSONArray(this.ITEMS).toJavaList(Company.class);
                }
            } else {
                log.error("\u5929\u773c\u67e5\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)reason);
            }
        }
        catch (Exception e) {
            log.error("\u5929\u773c\u67e5\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return Collections.emptyList();
    }
}

