/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.util;

import javax.servlet.http.HttpServletRequest;
import org.example.common.util.StringUtils;
import org.example.common.util.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);
    private static final String[] IP_HEADER_CANDIDATES = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR", "X-Real-IP"};

    public static String getIP() {
        HttpServletRequest request = WebUtil.getRequest();
        String ip = null;
        for (String header : IP_HEADER_CANDIDATES) {
            ip = request.getHeader(header);
            if (!StringUtils.isNotBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) continue;
            if (!IpUtil.isValidIpAddress(ip)) {
                log.warn("Invalid IP format for header: {}", (Object)header);
                ip = null;
                continue;
            }
            if (!header.equalsIgnoreCase("X-Forwarded-For")) break;
            ip = ip.split(",")[0];
            break;
        }
        if (ip == null || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
            log.info("getRemoteAddr ip: {}", (Object)ip);
        } else {
            log.info("Client IP from header: {}", (Object)ip);
        }
        return ip;
    }

    public static boolean isValidIpAddress(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        String[] parts = ipAddress.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String part : parts) {
            if (part.isEmpty() || part.length() > 3) {
                return false;
            }
            try {
                int num = Integer.parseInt(part);
                if (num >= 0 && num <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

