package org.example.common.session;

/**
 * @author liutao
 * @since 2024/5/10
 */
public class SessionUtil {

    private SessionUtil() {}

    private static final ThreadLocal<BaseSession> USER_SESSION_THREAD_LOCAL = new ThreadLocal<>();


    public static void set(BaseSession session) {
        USER_SESSION_THREAD_LOCAL.set(session);
    }

    public static BaseSession get() {
        return USER_SESSION_THREAD_LOCAL.get();
    }

    public static void clear() {
        USER_SESSION_THREAD_LOCAL.remove();
    }
}
