/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.util;

import com.alibaba.excel.annotation.ExcelProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.springframework.util.CollectionUtils;

public class ValidateUtil {
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();

    public static List<String> validateBean(Object obj) {
        Set constraintViolations = VALIDATOR.validate(obj, new Class[]{Default.class});
        if (CollectionUtils.isEmpty((Collection)constraintViolations)) {
            return Collections.emptyList();
        }
        return constraintViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
    }

    public static boolean isAllFieldNull(Object obj) {
        try {
            List fields = Arrays.stream(obj.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(ExcelProperty.class)).collect(Collectors.toList());
            ArrayList<Boolean> lineNullList = new ArrayList<Boolean>(fields.size());
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (Objects.isNull(value)) {
                    lineNullList.add(Boolean.TRUE);
                    continue;
                }
                lineNullList.add(Boolean.FALSE);
            }
            return lineNullList.stream().allMatch(Boolean.TRUE::equals);
        }
        catch (IllegalAccessException e) {
            return true;
        }
    }
}

