package org.example.common.ai;

import com.unfbx.chatgpt.OpenAiClient;
import com.unfbx.chatgpt.entity.chat.ChatChoice;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.ChatCompletionResponse;
import com.unfbx.chatgpt.entity.chat.Message;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

/**
 * @author liutao
 * @since 2024/6/20
 */
@Slf4j
@Service
@RequiredArgsConstructor
@ConditionalOnProperty(name = "openai.type", havingValue = "chatgpt")
public class ChatGptOpenAiServiceImpl implements OpenAiService {



    @Resource
    private OpenAiClient openAiClient;

    @Override
    public String send(String content) {
        try {
            Message message = Message.builder()
                    .role(Message.Role.USER)
                    .content(content)
                    .build();
            ChatCompletion chatCompletion = ChatCompletion.builder()
                    .model("gpt-3.5-turbo")  // 模型选择（chatGPT 默认为这个）
                    .messages(Collections.singletonList(message))  // 问题。一次课问答多条数据
                    .stream(false)   // 是否是流式问答，我选择的不是，需要等gpt回答完才能拿到完整数据
                    .build();

            ChatCompletionResponse chatCompletionResponse = openAiClient.chatCompletion(chatCompletion);
            List<ChatChoice> choices = chatCompletionResponse.getChoices();
            if (CollectionUtils.isEmpty(choices)) {
                return "";
            }
            ChatChoice chatChoice = choices.get(0);
            return chatChoice.getMessage().getContent();
        } catch (Exception e) {
            log.error(e.getMessage(),e);
            return "";
        }
    }


}
