package org.example.common.thirty.factory;

import org.example.common.enums.ShortLinkChannelEnum;
import org.example.common.thirty.ShortLinkService;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author liutao
 * @since 2024/3/8
 */
@Component
public class ShortLinkFactory {


    @Resource
    private List<ShortLinkService> shortLinkServices;

    private static final Map<ShortLinkChannelEnum, ShortLinkService> shortLinkServiceMap = new HashMap<>();

    @PostConstruct
    public void init() {
        for (ShortLinkService shortLinkService : shortLinkServices) {
            shortLinkServiceMap.put(shortLinkService.type(),shortLinkService);
        }
    }


    public ShortLinkService getShortLinkService(ShortLinkChannelEnum type) {
        return shortLinkServiceMap.get(type);
    }

}
