package org.example.common.util;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author liutao
 * @since 2024/4/7
 */
public class ExcelUtil {

    public static <T> List<T> read(InputStream inputStream, Class<T> clazz, Integer headRowNumber) {

        List<T> list = new ArrayList<>();
        EasyExcel.read(inputStream, clazz, new ReadListener<T>() {
            private int index = 0;
            @Override
            public void invoke(T data, AnalysisContext analysisContext) {
                index++;
                if (ValidateUtil.isAllFieldNull(data)) {
                    return;
                }
                try {
                    Field indexField = ReflectUtil.getField(clazz, "index");
                    if (Objects.nonNull(indexField)) {
                        indexField.setAccessible(true);
                        indexField.set(data,index);
                    }
                    List<String> errorList = ValidateUtil.validateBean(data);
                    if (!CollectionUtils.isEmpty(errorList)) {
                        Field errorMsgField = ReflectUtil.getField(clazz, "errorMsg");
                        if (Objects.nonNull(errorMsgField)) {
                            errorMsgField.setAccessible(true);
                            errorMsgField.set(data, "第"+index+"行数据校验失败，错误信息："+String.join(",", errorList));
                        }
                    }
                } catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                list.add(data);
            }

            @Override
            public void doAfterAllAnalysed(AnalysisContext analysisContext) {

            }
        }).ignoreEmptyRow(true).headRowNumber(headRowNumber).sheet().doRead();
        return list;
    }


    public static <T> void write(OutputStream outputStream, List<T> data, Class<T> clazz) {
        EasyExcel.write(outputStream,clazz).sheet().doWrite(data);
    }

    public static <T> void write(OutputStream outputStream, List<T> data, List<String> excludeColumnFiledNames, Class<T> clazz) {
        EasyExcel.write(outputStream,clazz).sheet().excludeColumnFiledNames(excludeColumnFiledNames).doWrite(data);
    }

    public static <T> void writeSheet(ExcelWriter writer, int sheetNo, String sheetName, Class<T> clazz, List<String> excludeColumnFiledNames, List<T> data) {
        WriteSheet writeSheet = EasyExcel.writerSheet(sheetNo, sheetName).head(clazz).excludeColumnFiledNames(excludeColumnFiledNames).build();
        writer.write(data,writeSheet);
    }


    public static OutputStream fillExcel(InputStream inputStream, List<T> data, Class<T> clazz) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        EasyExcel.write(os,clazz).withTemplate(inputStream).sheet(0).doFill(data);
        return os;
    }


    public static void setResponseHeader(HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xlsx");
        response.setHeader("Access-Control-Expose-Headers", "Content-disposition");
    }


    public static void downLoadTemplate(InputStream inputStream, HttpServletResponse response, String filename) throws IOException {
        response.setContentType("application/octet-stream");
        OutputStream out = response.getOutputStream();

        response.setHeader("Content-Disposition", "attachment;fileName=" + new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        IoUtil.copy(inputStream, out);
        inputStream.close();
    }


}
