package org.example.common.util;

import net.dreamlu.mica.http.HttpRequest;

import java.io.InputStream;
import java.util.Map;

/**
 * @author liutao
 * @since 2024/4/10
 */
public class HttpUtil {


    public static <T> T get(String url, final Map<String, String> headers, Class<T> clazz) {
        return get(url,headers,null,clazz);
    }

    public static <T> T get(String url, Class<T> clazz) {
        return HttpRequest.get(url)
                .execute().asValue(clazz);
    }

    public static <T> T get(String url, final Map<String, String> headers, Map<String,Object> queryMap, Class<T> clazz) {
        return HttpRequest.get(url)
                .addHeader(headers)
                .queryMap(queryMap)
                .execute().asValue(clazz);
    }

    public static void get(String url, final Map<String, String> headers, Map<String,Object> queryMap) {
        HttpRequest.get(url)
                .addHeader(headers)
                .queryMap(queryMap)
                .execute();
    }


    public static <T> T post(String url, final Map<String, String> headers, String body, Class<T> clazz) {
        return post(url,headers,null,body,clazz);
    }

    public static <T> T post(String url, String body, Class<T> clazz) {
        return HttpRequest.post(url)
                .bodyString(body).execute().asValue(clazz);
    }

    public static <T> T post(String url, final Map<String, String> headers, Map<String,Object> queryMap, String body, Class<T> clazz) {
        return HttpRequest.post(url)
                .addHeader(headers)
                .queryMap(queryMap)
                .bodyString(body).execute().asValue(clazz);
    }

    public static <T> T form(String url, final Map<String, String> headers, Map<String,Object> formMap, Class<T> clazz) {
        return HttpRequest.post(url)
                .addHeader(headers)
                .formBuilder()
                .addMap(formMap)
                .build()
                .execute().asValue(clazz);
    }

    public static InputStream download(String url) {
        return  HttpRequest.get(url)
                .executeAsyncAndJoin()
                .asStream();
    }
}
