package org.example.common.trans;

import lombok.RequiredArgsConstructor;
import org.example.common.ai.OpenAiService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

/**
 * @author liutao
 * @since 2024/6/20
 */
@Service
@RequiredArgsConstructor
@ConditionalOnProperty(name = "translate.type", havingValue = "chatgpt")
public class ChatGptTranslationServiceImpl implements TranslationService {

    private final OpenAiService openAiService;

    @Override
    public String translate(String content) {
        return translate(content, "中文", "英文");
    }

    @Override
    public String translate(String content, String sourceLanguage, String targetLanguage) {

        return openAiService.send(String.format("将这段文本从%s翻译成%s：%s", sourceLanguage, targetLanguage, content));
    }

    @Override
    public String translate(String content, String targetLanguage) {
        return translate(content, "中文", targetLanguage);
    }
}
