package org.example.common.thirty.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.example.common.thirty.TycService;
import org.example.common.thirty.entity.Company;
import org.example.common.util.HttpUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * @author liutao
 * @since 2024/4/22
 */
@Slf4j
@Service
@ConditionalOnProperty(name = "tyc.enable", havingValue = "true")
public class TycServiceImpl implements TycService {

    String TYC_COMPANY_SEARCH_URL = "http://open.api.tianyancha.com/services/open/search/2.0?word=%s&pageSize=%s&pageNum=%s";
    String TYC_TOKEN_NAME = "Authorization";
    String REASON = "reason";
    String RESULT = "result";
    String ITEMS = "items";
    Integer MAX_PAGE_SIZE = 20;
    String SUCCESS_REASON = "ok";


    @Value("${tyc.token}")
    private String token;

    @Override
    public List<Company> queryCompanyInfo(String name, Integer pageNum) {
        try {
            JSONObject jsonObject = HttpUtil.get(String.format(TYC_COMPANY_SEARCH_URL, name, MAX_PAGE_SIZE, pageNum), MapUtil.of(TYC_TOKEN_NAME, token), JSONObject.class);
            String reason = jsonObject.getString(REASON);
            if (SUCCESS_REASON.equals(reason)) {
                JSONObject result = jsonObject.getJSONObject(RESULT);
                if (result != null) {
                    return result.getJSONArray(ITEMS).toJavaList(Company.class);
                }
            }else {
                log.error("天眼查接口异常：{}",reason);
            }
        } catch (Exception e) {
            log.error("天眼查接口报错：{}", e.getMessage(), e);
        }
        return Collections.emptyList();
    }
}
