/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.ai;

import com.unfbx.chatgpt.OpenAiClient;
import com.unfbx.chatgpt.entity.chat.BaseChatCompletion;
import com.unfbx.chatgpt.entity.chat.BaseMessage;
import com.unfbx.chatgpt.entity.chat.ChatChoice;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.ChatCompletionResponse;
import com.unfbx.chatgpt.entity.chat.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.example.common.ai.OpenAiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnProperty(name={"openai.type"}, havingValue="chatgpt")
public class ChatGptOpenAiServiceImpl
implements OpenAiService {
    private static final Logger log = LoggerFactory.getLogger(ChatGptOpenAiServiceImpl.class);
    @Resource
    private OpenAiClient openAiClient;

    @Override
    public String send(String content) {
        try {
            Message message = Message.builder().role(BaseMessage.Role.USER).content(content).build();
            ChatCompletion chatCompletion = ((ChatCompletion.ChatCompletionBuilder)((ChatCompletion.ChatCompletionBuilder)ChatCompletion.builder().model("gpt-3.5-turbo")).messages(Collections.singletonList(message)).stream(false)).build();
            ChatCompletionResponse chatCompletionResponse = this.openAiClient.chatCompletion((BaseChatCompletion)chatCompletion);
            List choices = chatCompletionResponse.getChoices();
            if (CollectionUtils.isEmpty((Collection)choices)) {
                return "";
            }
            ChatChoice chatChoice = (ChatChoice)choices.get(0);
            return chatChoice.getMessage().getContent();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

