/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.aspect;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.extra.servlet.ServletUtil;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.example.common.anno.Idempotent;
import org.example.common.domain.R;
import org.example.common.lock.DistributedLock;
import org.example.common.lock.factory.DistributedLockFactory;
import org.example.common.util.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class IdempotentAspect {
    private static final Logger log = LoggerFactory.getLogger(IdempotentAspect.class);
    @Resource
    private DistributedLockFactory distributedLockFactory;
    private static final ExpressionParser PARSER = new SpelExpressionParser();

    @Pointcut(value="@annotation(org.example.common.anno.Idempotent)")
    public void idempotent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="idempotent()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        if (Objects.isNull(idempotent)) {
            return joinPoint.proceed();
        }
        String keySuffix = null;
        if (StringUtils.isNotBlank((CharSequence)idempotent.express())) {
            StandardEvaluationContext evaluationContext = this.getEvaluationContext(joinPoint);
            keySuffix = this.getElValue(idempotent.express(), evaluationContext);
        }
        String key = this.getKey(method, idempotent, keySuffix);
        log.info("aop\u5207\u9762redisKey\uff1a{}", (Object)key);
        DistributedLock distributedLock = this.distributedLockFactory.getDistributedLock(key);
        try {
            if (distributedLock.tryLock()) {
                Object object = joinPoint.proceed();
                return object;
            }
            log.info("redis\u5df2\u5b58\u5728key\uff0c\u91cd\u590d\u63d0\u4ea4");
            R r = R.fail("\u64cd\u4f5c\u9891\u7e41,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return r;
        }
        finally {
            if (distributedLock.isLocked()) {
                distributedLock.unlock();
            }
        }
    }

    private String getKey(Method method, Idempotent idempotent, String keySuffix) {
        String keyPrefix = idempotent.key();
        if (StringUtils.isBlank((CharSequence)keyPrefix)) {
            keyPrefix = "repeat_submit:";
        }
        if (StringUtils.isNotBlank((CharSequence)keySuffix)) {
            return keyPrefix + ":" + method.getDeclaringClass().getSimpleName() + ":" + method.getName() + ":" + keySuffix;
        }
        HttpServletRequest request = WebUtil.getRequest();
        String queryString = WebUtil.getQueryString(request);
        log.info("url\u53c2\u6570\uff1a{}", (Object)queryString);
        String body = ServletUtil.getBody((ServletRequest)request);
        log.info("body\u53c2\u6570\uff1a{}", (Object)body);
        String md5 = SecureUtil.md5((String)(queryString + body));
        return keyPrefix + ":" + md5;
    }

    private StandardEvaluationContext getEvaluationContext(ProceedingJoinPoint joinPoint) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)joinPoint.getArgs());
        return this.setContextVariables(context, (JoinPoint)joinPoint);
    }

    private StandardEvaluationContext setContextVariables(StandardEvaluationContext standardEvaluationContext, JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        LocalVariableTableParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
        Object[] parametersName = parameterNameDiscoverer.getParameterNames(targetMethod);
        if (ArrayUtil.isEmpty((Object[])args) || ArrayUtil.isEmpty((Object[])parametersName)) {
            return standardEvaluationContext;
        }
        for (int i = 0; i < args.length; ++i) {
            standardEvaluationContext.setVariable((String)parametersName[i], args[i]);
        }
        return standardEvaluationContext;
    }

    private String getElValue(String key, StandardEvaluationContext context) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return "";
        }
        Expression exp = PARSER.parseExpression(key);
        return (String)exp.getValue((EvaluationContext)context, String.class);
    }
}

