/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.exception;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.example.common.domain.R;
import org.example.common.enums.HttpCodeEnum;
import org.example.common.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ServiceExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ServiceExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public R<Object> handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return R.fail();
    }

    @ExceptionHandler(value={ServiceException.class})
    public R<Object> handleException(ServiceException e) {
        HttpCodeEnum httpCodeEnum = e.getHttpCodeEnum();
        if (Objects.nonNull((Object)httpCodeEnum)) {
            return R.result(httpCodeEnum);
        }
        return R.fail(e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public R<Object> methodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        return R.fail(Arrays.toString(bindingResult.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).toArray()));
    }

    @ExceptionHandler(value={BindException.class})
    public R<Object> handleBindException(BindException ex) {
        FieldError fieldError = ex.getBindingResult().getFieldError();
        if (Objects.nonNull(fieldError)) {
            log.error("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38:{}({})", (Object)fieldError.getDefaultMessage(), (Object)fieldError.getField());
            return R.fail(fieldError.getDefaultMessage());
        }
        return R.fail();
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public R<Object> missingServletRequestParameterException(MissingServletRequestParameterException e) {
        log.error(e.getMessage(), (Throwable)e);
        return R.result(HttpCodeEnum.PARAM_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public R<Object> constraintViolationException(ConstraintViolationException e) {
        log.error(e.getMessage(), (Throwable)e);
        String errorMessage = e.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(","));
        return R.fail("\u53c2\u6570\u6821\u9a8c\u5931\u8d25:" + errorMessage);
    }
}

