/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.trans;

import org.example.common.ai.OpenAiService;
import org.example.common.trans.TranslationService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"translate.type"}, havingValue="chatgpt")
public class ChatGptTranslationServiceImpl
implements TranslationService {
    private final OpenAiService openAiService;

    @Override
    public String translate(String content) {
        return this.translate(content, "\u4e2d\u6587", "\u82f1\u6587");
    }

    @Override
    public String translate(String content, String sourceLanguage, String targetLanguage) {
        return this.openAiService.send(String.format("\u5c06\u8fd9\u6bb5\u6587\u672c\u4ece%s\u7ffb\u8bd1\u6210%s\uff1a%s", sourceLanguage, targetLanguage, content));
    }

    @Override
    public String translate(String content, String targetLanguage) {
        return this.translate(content, "\u4e2d\u6587", targetLanguage);
    }

    public ChatGptTranslationServiceImpl(OpenAiService openAiService) {
        this.openAiService = openAiService;
    }
}

