/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.config;

import com.unfbx.chatgpt.OpenAiClient;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"openai.enable"}, havingValue="true")
public class ChatGptConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ChatGptConfiguration.class);
    @Value(value="${openai.apiKey}")
    private String apiKey;

    @Bean
    public OpenAiClient createClient() {
        return OpenAiClient.builder().apiKey(Collections.singletonList(this.apiKey)).build();
    }
}

