/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.mq.impl;

import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.example.common.mq.MessageSenderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"rocketmq.name-server"})
public class RocketMqMessageSenderServiceImpl
implements MessageSenderService {
    private static final Logger log = LoggerFactory.getLogger(RocketMqMessageSenderServiceImpl.class);
    @Resource
    private RocketMQTemplate rocketMQTemplate;
    @Value(value="${spring.profiles.active}")
    private String env;

    @Override
    public boolean send(String topic, Object message) {
        try {
            SendResult sendResult = this.rocketMQTemplate.syncSend(topic + this.env.toUpperCase(), (Object)this.getMessage(message));
            return SendStatus.SEND_OK.equals((Object)sendResult.getSendStatus());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean sendOrderly(String topic, Object message, String hashKey) {
        try {
            SendResult sendResult = this.rocketMQTemplate.syncSendOrderly(topic + this.env.toUpperCase(), (Object)this.getMessage(message), hashKey);
            return SendStatus.SEND_OK.equals((Object)sendResult.getSendStatus());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

