/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.util;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.example.common.util.ValidateUtil;
import org.springframework.util.CollectionUtils;

public class ExcelUtil {
    public static <T> List<T> read(InputStream inputStream, final Class<T> clazz, Integer headRowNumber) {
        final ArrayList list = new ArrayList();
        ((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, clazz, (ReadListener)new ReadListener<T>(){
            private int index = 0;

            public void invoke(T data, AnalysisContext analysisContext) {
                ++this.index;
                if (ValidateUtil.isAllFieldNull(data)) {
                    return;
                }
                try {
                    Field errorMsgField;
                    List<String> errorList;
                    Field indexField = ReflectUtil.getField((Class)clazz, (String)"index");
                    if (Objects.nonNull(indexField)) {
                        indexField.setAccessible(true);
                        indexField.set(data, this.index);
                    }
                    if (!CollectionUtils.isEmpty(errorList = ValidateUtil.validateBean(data)) && Objects.nonNull(errorMsgField = ReflectUtil.getField((Class)clazz, (String)"errorMsg"))) {
                        errorMsgField.setAccessible(true);
                        errorMsgField.set(data, String.join((CharSequence)",", errorList));
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                list.add(data);
            }

            public void doAfterAllAnalysed(AnalysisContext analysisContext) {
            }
        }).ignoreEmptyRow(Boolean.valueOf(true)).headRowNumber(headRowNumber)).sheet().doRead();
        return list;
    }

    public static <T> void write(OutputStream outputStream, List<T> data, Class<T> clazz) {
        EasyExcel.write((OutputStream)outputStream, clazz).sheet().doWrite(data);
    }

    public static <T> void write(OutputStream outputStream, List<T> data, List<String> excludeColumnFiledNames, Class<T> clazz) {
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)outputStream, clazz).sheet().excludeColumnFiledNames(excludeColumnFiledNames)).doWrite(data);
    }

    public static <T> void writeSheet(ExcelWriter writer, int sheetNo, String sheetName, Class<T> clazz, List<String> excludeColumnFiledNames, List<T> data) {
        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)sheetNo, (String)sheetName).head(clazz)).excludeColumnFiledNames(excludeColumnFiledNames)).build();
        writer.write(data, writeSheet);
    }

    public static <T> InputStream fillExcel(InputStream inputStream, List<T> data, Class<T> clazz) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        EasyExcel.write((OutputStream)os, clazz).withTemplate(inputStream).sheet(Integer.valueOf(0)).doFill(data);
        return new ByteArrayInputStream(os.toByteArray());
    }

    public static void setResponseHeader(HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xlsx");
        response.setHeader("Access-Control-Expose-Headers", "Content-disposition");
    }

    public static void downLoadTemplate(InputStream inputStream, HttpServletResponse response, String filename) throws IOException {
        response.setContentType("application/octet-stream");
        ServletOutputStream out = response.getOutputStream();
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        IoUtil.copy((InputStream)inputStream, (OutputStream)out);
        inputStream.close();
    }
}

