package org.example.common.lock;

import java.util.concurrent.TimeUnit;

/**
 * @author liutao
 * @since 2023/12/10
 */
public interface DistributedLock {

    /**
     * 获取锁
     * @param waitTime 等待时间
     * @param leaseTime 释放时间
     * @param unit 时间单位
     * @return true 获取锁成功 false 获取锁失败
     * @throws InterruptedException 中断异常
     */
    boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException;
    /**
     * 获取锁
     * @param waitTime 等待时间
     * @param unit 时间单位
     * @return true 获取锁成功 false 获取锁失败
     * @throws InterruptedException 中断异常
     */
    boolean tryLock(long waitTime,  TimeUnit unit) throws InterruptedException;
    /**
     * 获取锁
     * @return true 获取锁成功 false 获取锁失败
     * @throws InterruptedException 中断异常
     */
    boolean tryLock() throws InterruptedException;
    /**
     * 获取锁
     * @param leaseTime 释放时间
     * @param unit 时间单位
     */
    void lock(long leaseTime, TimeUnit unit);
    /**
     * 释放锁
     */
    void unlock();

    /**
     * 是否锁住
     * @return true false
     */
    boolean isLocked();

    /**
     * 检查锁是否由定义了threadId的线程持有
     * @param threadId threadId
     * @return true false
     */
    boolean isHeldByThread(long threadId);
    /**
     * 检查锁是否由当前线程持有
     * @return true false
     */
    boolean isHeldByCurrentThread();

}
