/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.cache.conversion;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson2.JSON;
import java.util.Collection;
import java.util.Objects;

public class TypeConversion {
    public static <T> boolean isCollectionType(T t) {
        return t instanceof Collection;
    }

    public static <T> boolean isSimpleType(T t) {
        return TypeConversion.isSimpleString(t) || TypeConversion.isInt(t) || TypeConversion.isLong(t) || TypeConversion.isDouble(t) || TypeConversion.isFloat(t) || TypeConversion.isChar(t) || TypeConversion.isBoolean(t) || TypeConversion.isShort(t) || TypeConversion.isByte(t);
    }

    public static <T> boolean isSimpleString(T t) {
        if (Objects.isNull(t) || !TypeConversion.isString(t)) {
            return false;
        }
        return !TypeConversion.isJsonString(t);
    }

    private static <T> boolean isJsonString(T t) {
        try {
            JSON.parseObject((String)t.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> boolean isString(T t) {
        return t instanceof String;
    }

    public static <T> boolean isByte(T t) {
        return t instanceof Byte;
    }

    public static <T> boolean isShort(T t) {
        return t instanceof Short;
    }

    public static <T> boolean isInt(T t) {
        return t instanceof Integer;
    }

    public static <T> boolean isLong(T t) {
        return t instanceof Long;
    }

    public static <T> boolean isChar(T t) {
        return t instanceof Character;
    }

    public static <T> boolean isFloat(T t) {
        return t instanceof Float;
    }

    public static <T> boolean isDouble(T t) {
        return t instanceof Double;
    }

    public static <T> boolean isBoolean(T t) {
        return t instanceof Boolean;
    }

    public static <T> Class<?> getClassType(T t) {
        return t.getClass();
    }

    public static <R> R convertor(String str, Class<R> type) {
        return (R)Convert.convert(type, (Object)str);
    }
}

