/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.oapi;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.lark.oapi.Client;
import com.lark.oapi.core.enums.BaseUrlEnum;
import com.lark.oapi.core.httpclient.IHttpTransport;
import com.lark.oapi.core.request.FormData;
import com.lark.oapi.core.request.FormDataFile;
import com.lark.oapi.core.request.RawRequest;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.utils.IOs;
import com.lark.oapi.core.utils.OKHttps;
import com.lark.oapi.okhttp.MediaType;
import com.lark.oapi.okhttp.MultipartBody;
import com.lark.oapi.okhttp.OkHttpClient;
import com.lark.oapi.okhttp.Request;
import com.lark.oapi.okhttp.RequestBody;
import com.lark.oapi.okhttp.Response;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.util.Strings;
import org.example.common.oapi.BiTableService;
import org.example.common.oapi.BiTableServiceImpl;
import org.example.common.oapi.OApiProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OApiConfig {
    @Bean
    @ConditionalOnProperty(name={"oapi.enable"}, havingValue="true")
    public Client client(OApiProperties oApiProperties) {
        return Client.newBuilder((String)oApiProperties.getAppId(), (String)oApiProperties.getAppSecret()).requestTimeout(30L, TimeUnit.SECONDS).openBaseUrl(BaseUrlEnum.FeiShu).httpTransport((IHttpTransport)new FsHttpTransport(OKHttps.create((long)30L, (TimeUnit)TimeUnit.SECONDS))).build();
    }

    @Bean
    @ConditionalOnProperty(name={"oapi.enable"}, havingValue="true")
    public BiTableService biTableService(Client client) {
        return new BiTableServiceImpl(client);
    }

    static class FsHttpTransport
    implements IHttpTransport {
        private final OkHttpClient okHttpClient;

        public FsHttpTransport(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
        }

        private RequestBody buildReqBody(RawRequest request) {
            if (request != null && request.getBody() != null) {
                Object body = request.getBody();
                if (!(body instanceof FormData)) {
                    return request.isSupportLong2String() ? RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (byte[])JSON.toJSONBytes((Object)body, (Charset)StandardCharsets.UTF_8, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteLongAsString, JSONWriter.Feature.WriteNulls})) : RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (byte[])JSON.toJSONBytes((Object)body, (Charset)StandardCharsets.UTF_8, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls}));
                }
                String contentType = "multipart/form-data;charset=" + StandardCharsets.UTF_8;
                MultipartBody.Builder builder = new MultipartBody.Builder().setType(Objects.requireNonNull(MediaType.parse((String)contentType)));
                FormData formData = (FormData)body;
                for (Map.Entry entry : formData.getParams().entrySet()) {
                    builder.addFormDataPart((String)entry.getKey(), entry.getValue().toString());
                }
                for (FormDataFile file : formData.getFiles()) {
                    File finalFile = file.getFile();
                    builder.addFormDataPart(file.getFieldName(), Strings.isEmpty((CharSequence)file.getFileName()) ? "unknown" : file.getFileName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)finalFile));
                }
                return builder.build();
            }
            return null;
        }

        public RawResponse execute(RawRequest request) throws Exception {
            RequestBody body = this.buildReqBody(request);
            Request.Builder builder = new Request.Builder().url(request.getReqUrl()).method(request.getHttpMethod(), body);
            for (Map.Entry entry : request.getHeaders().entrySet()) {
                for (String o : (List)entry.getValue()) {
                    builder.header((String)entry.getKey(), o);
                }
            }
            if (!(request.getBody() instanceof FormData)) {
                builder.header("content-type", "application/json; charset=utf-8");
            }
            Response response = this.okHttpClient.newCall(builder.build()).execute();
            RawResponse rawResponse = new RawResponse();
            rawResponse.setStatusCode(response.code());
            rawResponse.setHeaders(response.headers().toMultimap());
            if (request.isSupportDownLoad()) {
                assert (response.body() != null);
                rawResponse.setBody(Objects.requireNonNull(IOs.readAll((InputStream)response.body().byteStream())));
            } else {
                rawResponse.setBody(Objects.requireNonNull(response.body()).bytes());
            }
            return rawResponse;
        }
    }
}

