/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.trans;

import org.apache.commons.lang3.StringUtils;
import org.example.common.ai.OpenAiService;
import org.example.common.exception.ServiceException;
import org.example.common.trans.TranslationRequest;
import org.example.common.trans.TranslationService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"translate.type"}, havingValue="chatgpt")
public class ChatGptTranslationServiceImpl
implements TranslationService {
    private final OpenAiService openAiService;

    @Override
    public String translate(TranslationRequest translationRequest) {
        String from = translationRequest.getFrom();
        String to = translationRequest.getTo();
        String content = translationRequest.getContent();
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new ServiceException("\u7ffb\u8bd1\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)from)) {
            from = "cn";
        }
        if (StringUtils.isBlank((CharSequence)to)) {
            to = "en";
        }
        return this.openAiService.send(String.format("\u5c06\u8fd9\u6bb5\u6587\u672c\u4ece%s\u7ffb\u8bd1\u6210%s\uff1a%s", from, to, content));
    }

    public ChatGptTranslationServiceImpl(OpenAiService openAiService) {
        this.openAiService = openAiService;
    }
}

