package org.example.common.config;

import com.unfbx.chatgpt.OpenAiClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Collections;

/**
 * @author liutao
 * @since 2024/6/20
 */
@Slf4j
@Configuration
@ConditionalOnProperty(name = "openai.enable", havingValue = "true")
public class ChatGptConfiguration {


    @Value("${openai.apiKey}")
    private String apiKey;


    @Bean
    public OpenAiClient createClient() {
        return OpenAiClient.builder()
                .apiKey(Collections.singletonList(apiKey))
                .build();
    }


}
