package org.example.common.constant;

/**
 * 通用常量信息
 *
 * @author liutao
 */
public interface Constants {
    /**
     * http请求
     */
    String HTTP = "http://";

    /**
     * https请求
     */
    String HTTPS = "https://";

    /**
     * 防重提交 redis key
     */
    String REPEAT_SUBMIT_KEY = "repeat_submit:";

    String ACCESS_TOKEN = "access_token";
    /**
     * oss上传签名 redis key
     */
    String OSS_POST_SIGNATURE = "oss:post:signature";
    /**
     * 微信小程序短链token
     */
    String WX_MA_SHORT_LINK_TOKEN_KEY = "wx:ma:shortLink:token:";

    // 源语种
    String DEFAULT_FROM = "cn";
    // 目标语种
    String DEFAULT_TO = "en";
}
