package org.example.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author liutao
 * @since 2024/4/18
 */
@AllArgsConstructor
@Getter
public enum IdType {


    AUDIENCE(1, "普通观众"),
    TEAM(2, "团体观众"),
    ABROAD(3, "海外观众"),
    GLOBAL_RESOURCE(4,"环球资源"),
    EXPO_PROMOTER(5,"ExpoPromoter")
    ;


    private final int type;
    private final String name;

    public static IdType getByName(String name) {
        for (IdType idType : IdType.values()) {
            if (idType.getName().equals(name)) {
                return idType;
            }
        }
        return null;
    }
}
