package org.example.common.mq.impl;

import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.example.common.mq.MessageSenderService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author liutao
 * @since 2024/5/30
 */
@Slf4j
@Service
@ConditionalOnProperty(name = "rocketmq.name-server")
public class RocketMqMessageSenderServiceImpl implements MessageSenderService {

    @Resource
    private RocketMQTemplate rocketMQTemplate;
    @Value("${spring.profiles.active}")
    private String env;


    @Override
    public boolean send(String topic, Object message) {
        try{
            SendResult sendResult = rocketMQTemplate.syncSend(topic + env.toUpperCase(), this.getMessage(message));
            return SendStatus.SEND_OK.equals(sendResult.getSendStatus());
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return false;
        }
    }

    @Override
    public boolean sendOrderly(String topic, Object message, String hashKey) {
        try{
            SendResult sendResult = rocketMQTemplate.syncSendOrderly(topic + env.toUpperCase(), this.getMessage(message),hashKey);
            return SendStatus.SEND_OK.equals(sendResult.getSendStatus());
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return false;
        }
    }

}
