package org.example.common.thirty.entity;

import com.alibaba.fastjson2.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author liutao
 * @since 2024/11/25
 */
@Data
public class CompanyCustomerResult  implements Serializable {

    /**
     * 客户年份
     */
    private List<ClientsYear> clientsYear;

    /**
     * 分页对象
     */
    private PageBean pageBean;

    @Data
    public static class ClientsYear  implements Serializable{

        /**
         * 年份(数量)
         */
        private String title;

        /**
         * 年份
         */
        private String value;
    }

    @Data
    public static class PageBean  implements Serializable{

        /**
         * 总数
         */
        private Integer total;

        private List<CompanyCustomerData> result;
    }


    @Data
    public static class CompanyCustomerData  implements Serializable{

        /**
         * 报告期
         */
        @JSONField(name = "announcement_date")
        private Long announcementDate;

        /**
         * 销售金额(万元)
         */
        private BigDecimal amt;

        /**
         * 公司logo
         */
        private String logo;

        /**
         * 简称
         */
        private String alias;

        /**
         * 客户id
         */
        @JSONField(name = "client_graphId")
        private Long clientGraphId;

        /**
         * 关联关系
         */
        private String relationShip;

        /**
         * 客户名称
         */
        @JSONField(name = "client_name")
        private String clientName;

        /**
         * 数据来源
         */
        private String dataSource;

        /**
         * 销售占比
         */
        private String ratio;
    }
}
