package org.example.common.thirty.impl;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.URLEncodeUtil;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.example.common.thirty.TycService;
import org.example.common.thirty.entity.*;
import org.example.common.util.HttpUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * @author liutao
 * @since 2024/4/22
 */
@Slf4j
@Service
@ConditionalOnProperty(name = "tyc.enable", havingValue = "true")
public class TycServiceImpl implements TycService {


    private static final String TYC_TOKEN_NAME = "Authorization";
    private static final String REASON = "reason";
    private static final String RESULT = "result";
    private static final String ITEMS = "items";
    private static final Integer MAX_PAGE_SIZE = 20;
    private static final String SUCCESS_REASON = "ok";
    private static final String ERROR_CODE_KEY = "error_code";


    @Value("${tyc.token}")
    private String token;

    @Override
    public List<CompanySearchData> search(String name, Integer pageNum) {
        try {
            String TYC_COMPANY_SEARCH_URL = "https://open.api.tianyancha.com/services/open/search/2.0?word=%s&pageSize=%s&pageNum=%s";
            JSONObject jsonObject = HttpUtil.get(String.format(TYC_COMPANY_SEARCH_URL, name, MAX_PAGE_SIZE, pageNum), MapUtil.of(TYC_TOKEN_NAME, token), JSONObject.class);
            String reason = jsonObject.getString(REASON);
            if (SUCCESS_REASON.equals(reason)) {
                JSONObject result = jsonObject.getJSONObject(RESULT);
                if (result != null) {
                    return result.getJSONArray(ITEMS).toJavaList(CompanySearchData.class);
                }
            }else {
                log.error("天眼查接口异常：{}",reason);
            }
        } catch (Exception e) {
            log.error("天眼查接口报错：{}", e.getMessage(), e);
        }
        return Collections.emptyList();
    }

    @Override
    public CompanyBaseInfoData getCompanyBaseInfo(String keyword) {
        try {
            String url = "https://open.api.tianyancha.com/services/open/ic/baseinfo/normal?keyword="+ URLEncodeUtil.encode(keyword);
            JSONObject jsonObject = HttpUtil.get(url, MapUtil.of(TYC_TOKEN_NAME, token), JSONObject.class);
            Integer errorCode = jsonObject.getInteger(ERROR_CODE_KEY);
            if (errorCode == 0) {
                return jsonObject.getObject(RESULT, CompanyBaseInfoData.class);
            }
            log.error("天眼查查询企业基本信息接口异常：{}", jsonObject.getString(REASON));
        } catch (Exception e) {
            log.error("天眼查查询企业基本信息接口报错：{}", e.getMessage(), e);
        }
        return null;
    }

    @Override
    public CompanyProductResult getCompanyProduct(String keyword, Integer pageNum) {
        try {
            String url = "https://open.api.tianyancha.com/services/open/m/appbkInfo/2.0?pageSize=20&keyword=%s&pageNum=%s";
            JSONObject jsonObject = HttpUtil.get(String.format(url, URLEncodeUtil.encode(keyword), pageNum), MapUtil.of(TYC_TOKEN_NAME, token), JSONObject.class);
            Integer errorCode = jsonObject.getInteger(ERROR_CODE_KEY);
            if (errorCode == 0) {
                return jsonObject.getObject(RESULT,CompanyProductResult.class);
            }
            log.error("天眼查查询企业产品信息接口异常：{}", jsonObject.getString(REASON));
        } catch (UtilException e) {
            log.error("天眼查查询企业产品信息接口报错：{}", e.getMessage(), e);
        }
        return null;
    }

    @Override
    public CompanyCustomerResult getCompanyCustomer(String keyword, Integer pageNum, Integer year) {
        String url = "https://open.api.tianyancha.com/services/open/m/customer/2.0?year=%s&pageSize=20&keyword=%s&pageNum=%s";
        try {
            JSONObject jsonObject = HttpUtil.get(String.format(url, year, URLEncodeUtil.encode(keyword), pageNum), MapUtil.of(TYC_TOKEN_NAME, token), JSONObject.class);
            Integer errorCode = jsonObject.getInteger(ERROR_CODE_KEY);
            if (errorCode == 0) {
                return jsonObject.getObject(RESULT,CompanyCustomerResult.class);
            }
            log.error("天眼查查询企业客户信息接口异常：{}", jsonObject.getString(REASON));
        }catch (Exception e) {
            log.error("天眼查查询企业客户信息接口报错：{}", e.getMessage(), e);
        }
        return null;
    }

    @Override
    public CompanySupplyResult getCompanySupply(String keyword, Integer pageNum, Integer year) {
        String url = "https://open.api.tianyancha.com/services/open/m/supply/2.0?year=%s&pageSize=20&keyword=%s&pageNum=%s";
        try {
            JSONObject jsonObject = HttpUtil.get(String.format(url, year, URLEncodeUtil.encode(keyword), pageNum), MapUtil.of(TYC_TOKEN_NAME, token), JSONObject.class);
            Integer errorCode = jsonObject.getInteger(ERROR_CODE_KEY);
            if (errorCode == 0) {
                return jsonObject.getObject(RESULT,CompanySupplyResult.class);
            }
            log.error("天眼查查询企业供应商信息接口异常：{}", jsonObject.getString(REASON));
        }catch (Exception e) {
            log.error("天眼查查询企业供应商信息接口报错：{}", e.getMessage(), e);
        }
        return null;
    }

    @Override
    public CompanyGroupResult getCompanyGroup(String keyword) {
        String url = "https://open.api.tianyancha.com/services/open/group/base?keyword=%s";
        try {
            JSONObject jsonObject = HttpUtil.get(String.format(url, URLEncodeUtil.encode(keyword)), MapUtil.of(TYC_TOKEN_NAME, token), JSONObject.class);
            Integer errorCode = jsonObject.getInteger(ERROR_CODE_KEY);
            if (errorCode == 0) {
                return jsonObject.getObject(RESULT,CompanyGroupResult.class);
            }
            log.error("天眼查查询企业集团信息接口异常：{}", jsonObject.getString(REASON));
        }catch (Exception e) {
            log.error("天眼查查询企业集团信息接口报错：{}", e.getMessage(), e);
        }
        return null;
    }

    @Override
    public CompanyGroupMemberResult getCompanyGroupMember(Integer type, String uuid, Integer pageNum) {
        String url = "https://open.api.tianyancha.com/services/open/group/member?pageSize=20&type=%s&uuid=%s&pageNum=%s";
        try {
            JSONObject jsonObject = HttpUtil.get(String.format(url, type,uuid, pageNum),MapUtil.of(TYC_TOKEN_NAME, token), JSONObject.class);
            Integer errorCode = jsonObject.getInteger(ERROR_CODE_KEY);
            if (errorCode == 0) {
                return jsonObject.getObject(RESULT,CompanyGroupMemberResult.class);
            }
            log.error("天眼查查询企业集团成员信息接口异常：{}", jsonObject.getString(REASON));
        }catch (Exception e) {
            log.error("天眼查查询企业集团成员信息接口报错：{}", e.getMessage(), e);
        }
        return null;
    }
}
