package org.example.common.trans;

import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.example.common.ai.OpenAiService;
import org.example.common.constant.Constants;
import org.example.common.exception.ServiceException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

/**
 * @author liutao
 * @since 2024/6/20
 */
@Service
@RequiredArgsConstructor
@ConditionalOnProperty(name = "translate.type", havingValue = "chatgpt")
public class ChatGptTranslationServiceImpl implements TranslationService {

    private final OpenAiService openAiService;


    @Override
    public String translate(TranslationRequest translationRequest) {
        String from = translationRequest.getFrom();
        String to = translationRequest.getTo();
        String content = translationRequest.getContent();
        if (StringUtils.isBlank(content)) {
            throw new ServiceException("翻译文本不能为空");
        }
        if (StringUtils.isBlank(from)) {
            from = Constants.DEFAULT_FROM;
        }
        if (StringUtils.isBlank(to)) {
            to = Constants.DEFAULT_TO;
        }
        return openAiService.send(String.format("将这段文本从%s翻译成%s：%s", from, to, content));
    }
}
