package org.example.common.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;

/**
 * @author liutao
 * @since 2024/4/7
 */
public class WebUtil extends WebUtils {


    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie cookie = getCookie(request, name);
        if (Objects.nonNull(cookie)) {
            return cookie.getValue();
        }
        return null;
    }

    public static String getRequestUrlWithParam(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        String queryString = getQueryString(request);
        if (StringUtils.isNotBlank(queryString)) {
            return requestUri + "?" + queryString;
        }
        return requestUri;
    }

    public static String getQueryString(HttpServletRequest request) {
        Map<String, String[]> parameterMap = request.getParameterMap();
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            queryString.append(entry.getKey()).append("=").append(entry.getValue()[0]);
            queryString.append("&");
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }


    public static HttpServletRequest getRequest() {
        return  ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
    }

    public static <T extends Annotation> boolean hasAnno(HandlerMethod handlerMethod, Class<T> annotationClass) {
        return Objects.nonNull(handlerMethod.getMethod().getAnnotation(annotationClass));
    }
}
