/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.json.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import org.example.common.json.handler.BigNumberSerializer;
import org.example.common.json.handler.CustomDateDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JacksonConfig {
    private static final Logger log = LoggerFactory.getLogger(JacksonConfig.class);
    @Value(value="${spring.profiles.active}")
    private String profile;

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer customizer() {
        return builder -> {
            JavaTimeModule javaTimeModule = new JavaTimeModule();
            javaTimeModule.addSerializer(Long.class, (JsonSerializer)BigNumberSerializer.INSTANCE);
            javaTimeModule.addSerializer(Long.TYPE, (JsonSerializer)BigNumberSerializer.INSTANCE);
            javaTimeModule.addSerializer(BigInteger.class, (JsonSerializer)BigNumberSerializer.INSTANCE);
            javaTimeModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(formatter));
            javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(formatter));
            javaTimeModule.addDeserializer(Date.class, (JsonDeserializer)new CustomDateDeserializer());
            builder.modules(new Module[]{javaTimeModule});
            builder.timeZone(TimeZone.getTimeZone("Asia/Shanghai"));
            log.info("\u521d\u59cb\u5316 jackson \u914d\u7f6e");
        };
    }
}

