/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.util;

import java.io.InputStream;
import java.util.Map;
import net.dreamlu.mica.http.HttpRequest;
import net.dreamlu.mica.http.ResponseSpec;

public class HttpUtil {
    public static <T> T get(String url, Map<String, String> headers, Class<T> clazz) {
        return HttpUtil.get(url, headers, null, clazz);
    }

    public static String get(String url, Map<String, String> headers) {
        return (String)HttpRequest.get((String)url).addHeader(headers).execute().onResponse(ResponseSpec::asString);
    }

    public static <T> T get(String url, Class<T> clazz) {
        return (T)HttpRequest.get((String)url).execute().asValue(clazz);
    }

    public static <T> T get(String url, Map<String, String> headers, Map<String, Object> queryMap, Class<T> clazz) {
        return (T)HttpRequest.get((String)url).addHeader(headers).queryMap(queryMap).execute().asValue(clazz);
    }

    public static void get(String url, Map<String, String> headers, Map<String, Object> queryMap) {
        HttpRequest.get((String)url).addHeader(headers).queryMap(queryMap).execute();
    }

    public static <T> T post(String url, Map<String, String> headers, String body, Class<T> clazz) {
        return HttpUtil.post(url, headers, null, body, clazz);
    }

    public static <T> T post(String url, String body, Class<T> clazz) {
        return (T)HttpRequest.post((String)url).bodyString(body).execute().asValue(clazz);
    }

    public static <T> T post(String url, Map<String, String> headers, Map<String, Object> queryMap, String body, Class<T> clazz) {
        return (T)HttpRequest.post((String)url).addHeader(headers).queryMap(queryMap).bodyString(body).execute().asValue(clazz);
    }

    public static <T> T form(String url, Map<String, String> headers, Map<String, Object> formMap, Class<T> clazz) {
        return (T)HttpRequest.post((String)url).addHeader(headers).formBuilder().addMap(formMap).build().execute().asValue(clazz);
    }

    public static InputStream download(String url) {
        return HttpRequest.get((String)url).executeAsyncAndJoin().asStream();
    }
}

