/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.util;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.WebUtils;

public class WebUtil
extends WebUtils {
    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie cookie = WebUtil.getCookie((HttpServletRequest)request, (String)name);
        if (Objects.nonNull(cookie)) {
            return cookie.getValue();
        }
        return null;
    }

    public static String getRequestUrlWithParam(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        String queryString = WebUtil.getQueryString(request);
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            return requestUri + "?" + queryString;
        }
        return requestUri;
    }

    public static String getQueryString(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry entry : parameterMap.entrySet()) {
            queryString.append((String)entry.getKey()).append("=").append(((String[])entry.getValue())[0]);
            queryString.append("&");
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    public static <T extends Annotation> boolean hasAnno(HandlerMethod handlerMethod, Class<T> annotationClass) {
        return Objects.nonNull(handlerMethod.getMethod().getAnnotation(annotationClass));
    }
}

