package org.example.common.thirty;

import org.example.common.thirty.entity.*;

import java.util.List;

/**
 * @author liutao
 * @since 2024/4/22
 */
public interface TycService {

    /**
     * 搜索公司信息
     * @param name 公司名称
     * @return 公司信息
     */

    List<CompanySearchData> search(String name, Integer pageNum);


    /**
     * 获取公司基本信息
     * @param keyword 搜索关键字（公司名称、公司id、注册号或社会统一信用代码
     */
    CompanyBaseInfoData getCompanyBaseInfo(String keyword);

    /**
     * 获取公司产品信息
     * @param keyword 搜索关键字（公司名称、公司id、注册号或社会统一信用代码
     * @param pageNum 分页页码
     */
    CompanyProductResult getCompanyProduct(String keyword, Integer pageNum);


    /**
     * 获取公司客户信息
     * @param keyword 搜索关键字（公司名称、公司id、注册号或社会统一信用代码）
     * @param pageNum 当前⻚数（默认第1⻚）
     * @param year 年份（默认所有年份）
     */
    CompanyCustomerResult getCompanyCustomer(String keyword, Integer pageNum, Integer year);

    /**
     * 获取公司供应商信息
     * @param keyword 搜索关键字（公司名称、公司id、注册号或社会统一信用代码）
     * @param pageNum 当前⻚数（默认第1⻚）
     * @param year 年份（默认所有年份）
     */
    CompanySupplyResult getCompanySupply(String keyword, Integer pageNum, Integer year);

    /**
     * 获取公司所属集团
     * @param keyword 搜索关键字（公司名称、公司id、注册号或社会统一信用代码）
     */
    CompanyGroupResult getCompanyGroup(String keyword);

    /**
     * 获取集团成员信息
     * @param type 1-全部成员企业（默认），2-只核心企业
     * @param uuid 集团uuid
     * @param pageNum 当前⻚数（默认第1⻚
     */
    CompanyGroupMemberResult getCompanyGroupMember(Integer type, String uuid, Integer pageNum);
}
