package org.example.common.thirty.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author liutao
 * @since 2024/11/25
 */
@Data
public class CompanySupplyResult implements Serializable {


    /**
     * 客户年份
     */
    private List<SuppliesYear> suppliesYear;

    /**
     * 分页对象
     */
    private PageBean pageBean;

    @Data
    public static class SuppliesYear  implements Serializable{

        /**
         * 年份(数量)
         */
        private String title;

        /**
         * 年份
         */
        private String value;
    }

    @Data
    public static class PageBean  implements Serializable{

        /**
         * 总数
         */
        private Integer total;

        private List<CompanySupplyData> result;
    }


    @Data
    public static class CompanySupplyData  implements Serializable{

        /**
         * 报告期
         */
        @JsonProperty("announcement_date")
        private Long announcementDate;

        /**
         * 销售金额(万元)
         */
        private BigDecimal amt;

        /**
         * 公司logo
         */
        private String logo;

        /**
         * 简称
         */
        private String alias;

        /**
         * 客户id
         */
        @JsonProperty("supplier_graphId")
        private Long supplierGraphId;

        /**
         * 关联关系
         */
        private String relationShip;

        /**
         * 供应商名称
         */
        @JsonProperty("supplier_name")
        private String supplierName;

        /**
         * 数据来源
         */
        private String dataSource;

        /**
         * 销售占比
         */
        private String ratio;
    }
}
