/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.config;

import com.volcengine.ark.runtime.service.ArkService;
import java.time.Duration;
import java.util.List;
import org.example.common.ai.ChatService;
import org.example.common.ai.ToolCallBackProvider;
import org.example.common.ai.impl.ChatServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"ark.enable"}, havingValue="true")
public class ArkConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ArkConfiguration.class);
    @Value(value="${ark.apiKey:4d181319-59ee-42a4-8d83-f94d64de2041}")
    private String apiKey;
    @Value(value="${ark.timeout:60}")
    private int timeout;
    @Value(value="${ark.connectTimeout:60}")
    private int connectTimeout;
    @Value(value="${ark.retryTimes:3}")
    private int retryTimes;

    @Bean
    public ArkService arkService() {
        return ArkService.builder().apiKey(this.apiKey).timeout(Duration.ofSeconds(this.timeout)).connectTimeout(Duration.ofSeconds(this.connectTimeout)).retryTimes(this.retryTimes).build();
    }

    @Bean
    public ChatService chatService(ArkService arkService, List<ToolCallBackProvider> toolCallBackProviders) {
        return new ChatServiceImpl(arkService, toolCallBackProviders);
    }
}

