/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.thirty.impl;

import cn.hutool.core.map.MapUtil;
import java.util.Map;
import org.example.common.thirty.IdentityCardService;
import org.example.common.thirty.entity.IdentityCardResponse;
import org.example.common.util.HttpUtil;
import org.example.common.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class IdentityCardServiceImpl
implements IdentityCardService {
    private static final Logger log = LoggerFactory.getLogger(IdentityCardServiceImpl.class);
    private static final String URL = "https://zid.market.alicloudapi.com/idcard/VerifyIdcardv2?cardNo=%s&realName=%s";
    private static final String APP_CODE = "0411efcfca8d4d26898c68f48a974f26";

    @Override
    public boolean validateIdentityCard(String identityCard, String name) {
        try {
            name = StringUtils.trimAllWhitespace((String)name);
            identityCard = StringUtils.trimAllWhitespace((String)identityCard);
            IdentityCardResponse response = HttpUtil.get(String.format(URL, identityCard, name), (Map<String, String>)MapUtil.of((Object)"Authorization", (Object)"APPCODE 0411efcfca8d4d26898c68f48a974f26"), IdentityCardResponse.class);
            log.info("\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u54cd\u5e94:{}", (Object)JsonUtils.toJsonString(response));
            Integer errorCode = response.getErrorCode();
            if (errorCode != 0) {
                return false;
            }
            IdentityCardResponse.IdentityCardResult result = response.getResult();
            if (result == null) {
                return false;
            }
            return result.getSuccess();
        }
        catch (Exception e) {
            log.error("\u8eab\u4efd\u8bc1\u6821\u9a8c\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
            return true;
        }
    }
}

