/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.cache;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jeecgframework.poi.cache.manager.POICacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public final class ExcelCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelCache.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workbook getWorkbook(String url, Integer[] sheetNums, boolean needAll) {
        InputStream is = null;
        List<Integer> sheetList = Arrays.asList(sheetNums);
        try {
            is = POICacheManager.getFile(url);
            Workbook wb = WorkbookFactory.create((InputStream)is);
            if (!needAll) {
                for (int i = wb.getNumberOfSheets() - 1; i >= 0; --i) {
                    if (sheetList.contains(i)) continue;
                    wb.removeSheetAt(i);
                }
            }
            Workbook workbook = wb;
            return workbook;
        }
        catch (InvalidFormatException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workbook getWorkbookByTemplate(String url, Integer[] sheetNums, boolean needAll) {
        List<Integer> sheetList = Arrays.asList(sheetNums);
        InputStream fis = null;
        try {
            ClassPathResource resource = new ClassPathResource(url);
            fis = resource.getInputStream();
            Workbook wb = WorkbookFactory.create((InputStream)fis);
            if (!needAll) {
                for (int i = wb.getNumberOfSheets() - 1; i >= 0; --i) {
                    if (sheetList.contains(i)) continue;
                    wb.removeSheetAt(i);
                }
            }
            Workbook workbook = wb;
            return workbook;
        }
        catch (InvalidFormatException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

