/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.rx.integration;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ReturnValueHandler;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.MimeType;
import org.noear.solon.rx.handle.RxChainManager;
import org.noear.solon.rx.handle.RxContextDefault;
import org.noear.solon.web.rx.integration.RxHandlerImpl;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class RxReturnValueHandler
implements ReturnValueHandler {
    private final boolean hasReactor = ClassUtil.hasClass(() -> Flux.class);
    private RxChainManager chainManager = RxChainManager.getInstance();

    public boolean matched(Context ctx, Class<?> returnType) {
        return Publisher.class.isAssignableFrom(returnType);
    }

    public void returnHandle(Context ctx, Object result) throws Throwable {
        if (result != null) {
            RxContextDefault rxCtx = new RxContextDefault(ctx);
            boolean isStreaming = this.isStreaming(ctx);
            Publisher publisher = this.postPublisher(ctx, result, isStreaming);
            RxHandlerImpl handler = new RxHandlerImpl(publisher, isStreaming);
            this.chainManager.doFilter(rxCtx, handler).doOnError(err -> {
                try {
                    ctx.status(500);
                }
                finally {
                    if (ctx.asyncSupported()) {
                        ctx.asyncComplete();
                    }
                }
            }).doOnComplete(() -> {
                if (ctx.asyncSupported()) {
                    ctx.asyncComplete();
                }
            }).subscribe();
        }
    }

    protected boolean isStreaming(Context ctx) {
        return MimeType.isStreaming((String)ctx.contentTypeNew()) || MimeType.isStreaming((String)ctx.acceptNew());
    }

    protected Publisher postPublisher(Context ctx, Object result, boolean isStreaming) throws Throwable {
        if (this.hasReactor && result instanceof Flux && !isStreaming) {
            return ((Flux)result).collectList();
        }
        return (Publisher)result;
    }
}

