/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.util;

import java.util.ArrayList;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.util.Assert;

public final class PromptAssert {
    private PromptAssert() {
    }

    public static void templateHasRequiredPlaceholders(PromptTemplate promptTemplate, String ... placeholders) {
        Assert.notNull((Object)promptTemplate, (String)"promptTemplate cannot be null");
        Assert.notEmpty((Object[])placeholders, (String)"placeholders cannot be null or empty");
        ArrayList<String> missingPlaceholders = new ArrayList<String>();
        for (String placeholder : placeholders) {
            if (promptTemplate.getTemplate().contains(placeholder)) continue;
            missingPlaceholders.add(placeholder);
        }
        if (!missingPlaceholders.isEmpty()) {
            throw new IllegalArgumentException("The following placeholders must be present in the prompt template: %s".formatted(String.join((CharSequence)",", missingPlaceholders)));
        }
    }
}

