/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.boot;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.boot.BeanSearcherAutoConfiguration;
import cn.zhxu.bs.boot.prop.BeanSearcherFieldConvertor;
import cn.zhxu.bs.boot.prop.BeanSearcherParams;
import cn.zhxu.bs.convertor.B2MFieldConvertor;
import cn.zhxu.bs.convertor.BoolFieldConvertor;
import cn.zhxu.bs.convertor.BoolNumFieldConvertor;
import cn.zhxu.bs.convertor.BoolParamConvertor;
import cn.zhxu.bs.convertor.DateFieldConvertor;
import cn.zhxu.bs.convertor.DateFormatFieldConvertor;
import cn.zhxu.bs.convertor.DateParamConvertor;
import cn.zhxu.bs.convertor.DateTimeParamConvertor;
import cn.zhxu.bs.convertor.EnumFieldConvertor;
import cn.zhxu.bs.convertor.EnumParamConvertor;
import cn.zhxu.bs.convertor.ListFieldConvertor;
import cn.zhxu.bs.convertor.NumberFieldConvertor;
import cn.zhxu.bs.convertor.NumberParamConvertor;
import cn.zhxu.bs.convertor.StrNumFieldConvertor;
import cn.zhxu.bs.convertor.TimeFieldConvertor;
import cn.zhxu.bs.convertor.TimeParamConvertor;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BeanSearcherConvertors {
    @Bean
    @ConditionalOnMissingBean(value={BoolParamConvertor.class})
    public BoolParamConvertor boolParamConvertor() {
        return new BoolParamConvertor();
    }

    @Bean
    @ConditionalOnMissingBean(value={NumberParamConvertor.class})
    public NumberParamConvertor numberParamConvertor() {
        return new NumberParamConvertor();
    }

    @Bean
    @ConditionalOnMissingBean(value={DateParamConvertor.class})
    public DateParamConvertor dateParamConvertor(BeanSearcherParams config) {
        return new DateParamConvertor(config.getConvertor().getDateTarget());
    }

    @Bean
    @ConditionalOnMissingBean(value={TimeParamConvertor.class})
    public TimeParamConvertor timeParamConvertor(BeanSearcherParams config) {
        return new TimeParamConvertor(config.getConvertor().getTimeTarget());
    }

    @Bean
    @ConditionalOnMissingBean(value={DateTimeParamConvertor.class})
    public DateTimeParamConvertor dateTimeParamConvertor(BeanSearcherParams config) {
        BeanSearcherParams.Convertor conf = config.getConvertor();
        DateTimeParamConvertor convertor = new DateTimeParamConvertor(conf.getDateTimeTarget());
        convertor.setZoneId(conf.getZoneId());
        return convertor;
    }

    @Bean
    @ConditionalOnMissingBean(value={EnumParamConvertor.class})
    public EnumParamConvertor enumParamConvertor() {
        return new EnumParamConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-number"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={NumberFieldConvertor.class})
    public NumberFieldConvertor numberFieldConvertor() {
        return new NumberFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-str-num"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={StrNumFieldConvertor.class})
    public StrNumFieldConvertor strNumFieldConvertor() {
        return new StrNumFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-bool-num"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={BoolNumFieldConvertor.class})
    public BoolNumFieldConvertor boolNumFieldConvertor() {
        return new BoolNumFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-bool"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={BoolFieldConvertor.class})
    public BoolFieldConvertor boolFieldConvertor(BeanSearcherFieldConvertor config) {
        String[] falseValues = config.getBoolFalseValues();
        BoolFieldConvertor convertor = new BoolFieldConvertor();
        if (falseValues != null) {
            convertor.addFalseValues(falseValues);
        }
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-date"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={DateFieldConvertor.class})
    public DateFieldConvertor dateFieldConvertor(BeanSearcherFieldConvertor config) {
        DateFieldConvertor convertor = new DateFieldConvertor();
        ZoneId zoneId = config.getZoneId();
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-time"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={TimeFieldConvertor.class})
    public TimeFieldConvertor timeFieldConvertor() {
        return new TimeFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-enum"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={EnumFieldConvertor.class})
    public EnumFieldConvertor enumFieldConvertor(BeanSearcherFieldConvertor config) {
        EnumFieldConvertor convertor = new EnumFieldConvertor();
        convertor.setFailOnError(config.isEnumFailOnError());
        convertor.setIgnoreCase(config.isEnumIgnoreCase());
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-list"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={ListFieldConvertor.class})
    public ListFieldConvertor listFieldConvertor(BeanSearcherFieldConvertor config, ObjectProvider<List<ListFieldConvertor.Convertor<?>>> convertorsProvider) {
        ListFieldConvertor convertor = new ListFieldConvertor(config.getListItemSeparator());
        BeanSearcherAutoConfiguration.ifAvailable(convertorsProvider, arg_0 -> ((ListFieldConvertor)convertor).setConvertors(arg_0));
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-date-format"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={DateFormatFieldConvertor.class})
    public DateFormatFieldConvertor dateFormatFieldConvertor(BeanSearcherFieldConvertor config) {
        ZoneId zoneId;
        DateFormatFieldConvertor convertor = new DateFormatFieldConvertor();
        Map<String, String> dateFormats = config.getDateFormats();
        if (dateFormats != null) {
            dateFormats.forEach((key, value) -> {
                String scope = key.replace('-', ':');
                convertor.setFormat(scope, value);
            });
        }
        if ((zoneId = config.getZoneId()) != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-b2-m"}, havingValue="true")
    @ConditionalOnMissingBean(value={B2MFieldConvertor.class})
    public B2MFieldConvertor b2mFieldConvertor(ObjectProvider<List<FieldConvertor.BFieldConvertor>> convertors) {
        List list = (List)convertors.getIfAvailable();
        if (list != null) {
            return new B2MFieldConvertor(list);
        }
        return new B2MFieldConvertor(Collections.emptyList());
    }
}

