/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.exception.CompareNotSupportedException;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorPattern;
import com.googlecode.aviator.runtime.type.AviatorStringBuilder;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.TypeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class AviatorString
extends AviatorObject {
    private static final long serialVersionUID = -7430694306919959899L;
    private final String lexeme;
    private final boolean isLiteral;
    private boolean hasInterpolation = true;
    private int lineNo;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
        }
    };
    private static int COMPILE_TIMES = 0;

    @Override
    public String desc(Map<String, Object> env) {
        String val = this.getLexeme(env, false);
        if (val != this) {
            return "<" + this.getAviatorType() + ", " + val + ">";
        }
        return "<" + this.getAviatorType() + ", this>";
    }

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.String;
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        return this.getLexeme(env);
    }

    public AviatorString(String lexeme) {
        this(lexeme, false);
    }

    public AviatorString(String lexeme, boolean isLiteral) {
        this.lexeme = lexeme;
        this.isLiteral = isLiteral;
    }

    public AviatorString(String lexeme, boolean isLiteral, boolean hasInterpolation, int lineNo) {
        this.lexeme = lexeme;
        this.isLiteral = isLiteral;
        this.hasInterpolation = hasInterpolation;
        this.lineNo = lineNo;
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        StringBuilder sb = new StringBuilder(this.getLexeme(env));
        if (other.getAviatorType() != AviatorType.Pattern) {
            sb.append(other.getValue(env));
        } else {
            AviatorPattern otherPatterh = (AviatorPattern)other;
            sb.append(otherPatterh.pattern.pattern());
        }
        return new AviatorStringBuilder(sb);
    }

    private int tryCompareDate(Map<String, Object> env, Date otherDate) {
        try {
            SimpleDateFormat simpleDateFormat = DATE_FORMATTER.get();
            Date thisDate = simpleDateFormat.parse(this.getLexeme(env));
            return thisDate.compareTo(otherDate);
        }
        catch (Throwable t) {
            throw new ExpressionRuntimeException("Compare date error", t);
        }
    }

    @Override
    public int innerCompare(AviatorObject other, Map<String, Object> env) {
        String left = this.getLexeme(env);
        if (other.getAviatorType() == AviatorType.String) {
            AviatorString otherString = (AviatorString)other;
            String right = otherString.getLexeme(env);
            if (left != null && right != null) {
                return left.compareTo(right);
            }
            if (left == null && right != null) {
                return -1;
            }
            if (left != null && right == null) {
                return 1;
            }
            return 0;
        }
        switch (other.getAviatorType()) {
            case JavaType: {
                AviatorJavaType javaType = (AviatorJavaType)other;
                Object otherJavaValue = javaType.getValue(env);
                if (left == null && otherJavaValue == null) {
                    return 0;
                }
                if (left != null && otherJavaValue == null) {
                    return 1;
                }
                if (TypeUtils.isString(otherJavaValue)) {
                    if (left == null) {
                        return -1;
                    }
                    return left.compareTo(String.valueOf(otherJavaValue));
                }
                if (otherJavaValue instanceof Date) {
                    return this.tryCompareDate(env, (Date)otherJavaValue);
                }
                throw new CompareNotSupportedException("Could not compare " + this.desc(env) + " with " + other.desc(env));
            }
            case Nil: {
                if (left == null) {
                    return 0;
                }
                return 1;
            }
        }
        throw new CompareNotSupportedException("Could not compare " + this.desc(env) + " with " + other.desc(env));
    }

    public String getLexeme(Map<String, Object> env) {
        return this.getLexeme(env, true);
    }

    public String getLexeme(Map<String, Object> env, boolean warnOnCompile) {
        AviatorEvaluatorInstance engine = RuntimeUtils.getInstance(env);
        if (!(this.isLiteral && this.hasInterpolation && engine.isFeatureEnabled(Feature.StringInterpolation) && this.lexeme != null && this.lexeme.length() >= 3)) {
            return this.lexeme;
        }
        AviatorEvaluatorInstance.StringSegments segs = null;
        BaseExpression exp = (BaseExpression)(env == null || !(env instanceof Env) ? null : ((Env)env).getExpression());
        if (exp != null) {
            segs = exp.getStringSegements(this.lexeme, this.lineNo);
        } else {
            segs = engine.compileStringSegments(this.lexeme);
            if (warnOnCompile) {
                this.warnOnCompileWithoutCaching();
            }
        }
        assert (segs != null);
        return segs.toString(env, this.lexeme);
    }

    private void warnOnCompileWithoutCaching() {
        if (COMPILE_TIMES++ % 1000 == 0) {
            StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
            StringBuilder sb = new StringBuilder();
            boolean wasFirst = true;
            for (StackTraceElement st : stackTraces) {
                if (!wasFirst) {
                    sb.append("\t").append(st.toString()).append("\n");
                }
                if (!wasFirst) continue;
                wasFirst = false;
            }
            System.err.println("[Aviator WARN] compile lexeme `" + this.lexeme + "` without caching, it may hurt performance and cause metaspace full gc, the stack:\n" + sb.toString());
        }
    }
}

