/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;

public class Insert
extends Transform {
    private final int position;
    private final Class<?>[] types;
    private final Object[] values;

    public Insert(int position, Object ... values) {
        this.position = position;
        this.values = values;
        Class[] types = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            types[i] = values[i].getClass();
        }
        this.types = types;
    }

    public Insert(int position, boolean value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Boolean.TYPE};
    }

    public Insert(int position, boolean ... values) {
        this.position = position;
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
        this.types = (Class[])Collections.nCopies(values.length, Boolean.TYPE).stream().toArray(Class[]::new);
    }

    public Insert(int position, byte value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Byte.TYPE};
    }

    public Insert(int position, byte ... values) {
        this.position = position;
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
        this.types = (Class[])Collections.nCopies(values.length, Byte.TYPE).stream().toArray(Class[]::new);
    }

    public Insert(int position, short value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Short.TYPE};
    }

    public Insert(int position, short ... values) {
        this.position = position;
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
        this.types = (Class[])Collections.nCopies(values.length, Short.TYPE).stream().toArray(Class[]::new);
    }

    public Insert(int position, char value) {
        this.position = position;
        this.values = new Object[]{Character.valueOf(value)};
        this.types = new Class[]{Character.TYPE};
    }

    public Insert(int position, char ... values) {
        this.position = position;
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = Character.valueOf(values[i]);
        }
        this.types = (Class[])Collections.nCopies(values.length, Character.TYPE).stream().toArray(Class[]::new);
    }

    public Insert(int position, int value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Integer.TYPE};
    }

    public Insert(int position, int ... values) {
        this.position = position;
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
        this.types = (Class[])Collections.nCopies(values.length, Integer.TYPE).stream().toArray(Class[]::new);
    }

    public Insert(int position, long value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Long.TYPE};
    }

    public Insert(int position, long ... values) {
        this.position = position;
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
        this.types = (Class[])Collections.nCopies(values.length, Long.TYPE).stream().toArray(Class[]::new);
    }

    public Insert(int position, float value) {
        this.position = position;
        this.values = new Object[]{Float.valueOf(value)};
        this.types = new Class[]{Float.TYPE};
    }

    public Insert(int position, float ... values) {
        this.position = position;
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = Float.valueOf(values[i]);
        }
        this.types = (Class[])Collections.nCopies(values.length, Float.TYPE).stream().toArray(Class[]::new);
    }

    public Insert(int position, double value) {
        this.position = position;
        this.values = new Object[]{value};
        this.types = new Class[]{Double.TYPE};
    }

    public Insert(int position, double ... values) {
        this.position = position;
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
        this.types = (Class[])Collections.nCopies(values.length, Double.TYPE).stream().toArray(Class[]::new);
    }

    public Insert(int position, Class<?>[] types, Object ... values) {
        this.position = position;
        this.values = values;
        this.types = types;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return MethodHandles.insertArguments(target, this.position, this.values);
    }

    @Override
    public MethodType down(MethodType type) {
        return type.insertParameterTypes(this.position, this.types);
    }

    @Override
    public String toString() {
        return "insert " + Arrays.toString(this.types) + " at " + this.position;
    }

    @Override
    public String toJava(MethodType incoming) {
        StringBuilder builder = new StringBuilder("handle = MethodHandles.insertArguments(handle, ");
        builder.append(this.position).append(", ");
        boolean second = false;
        for (int i = 0; i < this.types.length; ++i) {
            if (second) {
                builder.append(", ");
            }
            second = true;
            Insert.buildClassCast(builder, this.types[i]);
            if (this.types[i].isPrimitive()) {
                Insert.buildPrimitiveJava(builder, this.values[i]);
                continue;
            }
            builder.append("value").append(i + 1);
        }
        builder.append(");");
        return builder.toString();
    }
}

